<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TipoDistribuidora extends Model 
{

    protected $table = 'tipo_distribuidoras';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'name');
    protected $visible = array('code', 'name');

    public function distribuidoras()
    {
        return $this->hasMany('Distribuidora', 'tipo_distribuidora_id')->withTrashed();
    }

}